/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.EnumSet;
import mods.flammpfeil.slashblade.ability.Untouchable;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class Guard {
    public static final ResourceLocation ADVANCEMENT_GUARD = new ResourceLocation("slashblade", "abilities/guard");
    public static final ResourceLocation ADVANCEMENT_GUARD_JUST = new ResourceLocation("slashblade", "abilities/guard_just");
    static final EnumSet<InputCommand> move = EnumSet.of(InputCommand.FORWARD, InputCommand.BACK, InputCommand.LEFT, InputCommand.RIGHT);

    public static Guard getInstance() {
        return SingletonHolder.instance;
    }

    private Guard() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        Entity entity;
        boolean isProjectile;
        LivingEntity victim = event.getEntity();
        DamageSource source = event.getSource();
        ItemStack stack = victim.m_21205_();
        LazyOptional slashBlade = stack.getCapability(CapabilitySlashBlade.BLADESTATE);
        if (!slashBlade.isPresent()) {
            return;
        }
        if (slashBlade.filter(b -> b.isBroken()).isPresent()) {
            return;
        }
        if (stack.getEnchantmentLevel(Enchantments.f_44972_) <= 0) {
            return;
        }
        if (!victim.m_20096_()) {
            return;
        }
        LazyOptional input = victim.getCapability(CapabilityInputState.INPUT_STATE);
        if (!input.isPresent()) {
            return;
        }
        InputCommand targetCommand = InputCommand.SNEAK;
        boolean handleCommand = input.filter(i -> i.getCommands().contains((Object)targetCommand) && !i.getCommands().stream().anyMatch(cc -> move.contains(cc))).isPresent();
        if (handleCommand) {
            AdvancementHelper.grantCriterion(victim, ADVANCEMENT_GUARD);
        }
        if (!(handleCommand |= input.filter(i -> i.getCommands().contains((Object)InputCommand.SPRINT)).isPresent() && victim.m_20142_())) {
            return;
        }
        if (!this.isInsideGuardableRange(source, victim)) {
            return;
        }
        long timeStartPress = (Long)input.map(i -> {
            Long l = i.getLastPressTime(targetCommand);
            return l == null ? 0L : l;
        }).get();
        long timeCurrent = victim.m_9236_().m_46467_();
        int soulSpeedLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44976_, (LivingEntity)victim);
        int justAcceptancePeriod = 5 + soulSpeedLevel;
        boolean isJust = false;
        if (timeCurrent - timeStartPress < (long)justAcceptancePeriod) {
            isJust = true;
            AdvancementHelper.grantedIf(Enchantments.f_44976_, victim);
        }
        boolean isHighRank = false;
        LazyOptional rank = victim.getCapability(CapabilityConcentrationRank.RANK_POINT);
        if (rank.filter(r -> IConcentrationRank.ConcentrationRanks.S.level <= r.getRank((long)timeCurrent).level).isPresent()) {
            isHighRank = true;
        }
        boolean bl = isProjectile = source.m_269533_(DamageTypeTags.f_268524_) || source.m_7640_() instanceof Projectile;
        if (!isJust) {
            if (!isProjectile) {
                return;
            }
            if (!isHighRank && source.m_269533_(DamageTypeTags.f_268490_)) {
                return;
            }
            boolean inMotion = slashBlade.filter(s -> {
                ResourceLocation current = s.resolvCurrentComboState(victim);
                ComboState currentCS = (ComboState)ComboStateRegistry.REGISTRY.get().getValue(current);
                return !current.equals((Object)ComboStateRegistry.NONE.getId()) && current == currentCS.getNext(victim);
            }).isPresent();
            if (inMotion) {
                return;
            }
        } else if (!isProjectile && !(source.m_7640_() instanceof LivingEntity)) {
            return;
        }
        event.setCanceled(true);
        if (isJust) {
            slashBlade.ifPresent(s -> s.updateComboSeq(victim, ComboStateRegistry.COMBO_A1.getId()));
        } else {
            slashBlade.ifPresent(s -> s.updateComboSeq(victim, ComboStateRegistry.COMBO_A1_END2.getId()));
        }
        if (!isProjectile && (entity = source.m_7640_()) instanceof LivingEntity) {
            ((LivingEntity)entity).m_147240_(0.5, entity.m_20185_() - victim.m_20185_(), entity.m_20189_() - victim.m_20189_());
        }
        if (isJust) {
            Untouchable.setUntouchable(victim, 10);
        }
        if (isJust) {
            rank.ifPresent(r -> r.addRankPoint(victim.m_9236_().m_269111_().m_269374_((Entity)victim)));
        }
        if (victim instanceof Player) {
            victim.m_5496_(SoundEvents.f_12515_, 1.0f, 1.0f + victim.m_9236_().m_213780_().m_188501_() * 0.4f);
        }
        if (isJust) {
            AdvancementHelper.grantCriterion(victim, ADVANCEMENT_GUARD_JUST);
        }
        if (!isJust && !isHighRank) {
            slashBlade.ifPresent(s -> stack.m_41622_(1, victim, ItemSlashBlade.getOnBroken(stack)));
        }
    }

    public boolean isInsideGuardableRange(DamageSource source, LivingEntity victim) {
        Vec3 sPos = source.m_7270_();
        if (sPos != null) {
            Vec3 viewVec = victim.m_20252_(1.0f);
            Vec3 attackVec = sPos.m_82505_(victim.m_20182_()).m_82541_();
            attackVec = new Vec3(attackVec.f_82479_, 0.0, attackVec.f_82481_);
            if (attackVec.m_82526_(viewVec) < 0.0) {
                return true;
            }
        }
        return false;
    }

    private static final class SingletonHolder {
        private static final Guard instance = new Guard();

        private SingletonHolder() {
        }
    }
}

